<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use App\Models\Currency;

class CurrencyRatesUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $currencies;

    public function __construct($currencies)
    {
        $this->currencies = $currencies;
    }

    public function broadcastOn()
    {
        return new Channel('currency-rates');
    }

    public function broadcastWith()
    {
        return [
            'currencies' => $this->currencies->map(function ($currency) {
                return [
                    'id' => $currency->id,
                    'code' => $currency->code,
                    'name' => $currency->name,
                    'bid' => $currency->bid,
                    'ask' => $currency->ask,
                    'has_bid_changed' => $currency->has_bid_changed,
                    'has_ask_changed' => $currency->has_ask_changed,
                    'old_bid' => $currency->old_bid,
                    'old_ask' => $currency->old_ask,
                ];
            })
        ];
    }
} 