<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;

class TransactionController extends Controller
{
    /**
     * Display a listing of the deposit and withdrawal transactions.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $transactions = Transaction::with('user') // Eager load user to prevent N+1 queries
            ->whereIn('type', ['deposit', 'withdraw'])
            ->orderBy('created_at', 'desc')
            ->get();
            
        return view('admin.transactions', compact('transactions'));
    }

    /**
     * Confirm a pending transaction.
     *
     * @param  \App\Models\Transaction  $transaction
     * @return \Illuminate\Http\RedirectResponse
     */
    public function confirm(Transaction $transaction)
    {
        if ($transaction->type == 'deposit' && !$transaction->confirmed) {
            $transaction->update(['confirmed' => true]);
            // Optionally, you might want to update the user's balance here
            // $transaction->user->balance += $transaction->amount;
            // $transaction->user->save();
            return redirect()->route('admin.transactions')->with('success', 'Transaction #' . $transaction->id . ' confirmed successfully.');
        } else {
            return redirect()->route('admin.transactions')->with('error', 'Transaction cannot be confirmed or is not a deposit.');
        }
    }
} 