<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Database\Eloquent\Model;

class RealTimeProperty extends Component
{
    public Model $model;
    public string $property;
    public $value;
    public $showClass;

    public function mount(Model $model, string $property, $showClass = null)
    {
        $this->model = $model;
        $this->property = $property;
        $this->showClass = $showClass;
        $this->value = $this->getValue();
    }

    public function getValue()
    {
        // Handle nested properties (e.g., "currency.bid")
        if (strpos($this->property, '.') !== false) {
            $parts = explode('.', $this->property);
            $value = $this->model;
            foreach ($parts as $part) {
                if (is_object($value)) {
                    $value = $value->{$part};
                } else {
                    return null;
                }
            }
            return $value;
        }

        // Handle method calls
        if (method_exists($this->model, $this->property)) {
            return $this->model->{$this->property}();
        }

        // Handle regular properties
        return $this->model->{$this->property};
    }

    public function render()
    {
        $this->value = $this->getValue();
        return view('livewire.real-time-property');
    }
} 