<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('type_id')->nullable();
            $table->string('code');
            $table->string('chart_code')->nullable(true);
            $table->string('name')->nullable(true);
            $table->double('profit_percentage')->nullable();
            $table->boolean('enabled')->default(0);
            $table->timestamps();

            
            $table->foreign('type_id')->references('id')->on('currency_types')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('currencies');
    }
};
