<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('currencies', function (Blueprint $table) {
            $table->dropColumn('old_rate');
            $table->decimal('old_bid', 20, 8)->nullable();
            $table->decimal('old_ask', 20, 8)->nullable();
        });
    }

    public function down()
    {
        Schema::table('currencies', function (Blueprint $table) {
            $table->decimal('old_rate', 20, 8)->nullable();
            $table->dropColumn(['old_bid', 'old_ask']);
        });
    }
}; 