<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="mb-3">
                        <i class="icon ion-md-map mr-1"></i>
                        Addresses Management
                    </div>
                    
                    <ul class="nav nav-pills card-header-pills">
                        
                        <li class="nav-item mr-5">
                            
                        <div class="input-group" style="width: 250px;">
                            <input type="text" wire:model.live="search" class="form-control float-right" placeholder="Search...">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link active" wire:click="$set('showAddModal', true)">Add Addresses</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th wire:click="sortBy('id')" style="cursor: pointer;">
                                    ID
                                    @if($sortField === 'id')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th wire:click="sortBy('address')" style="cursor: pointer;">
                                    Address
                                    @if($sortField === 'address')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th wire:click="sortBy('user_id')" style="cursor: pointer;">
                                    User
                                    @if($sortField === 'user_id')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($addresses as $address)
                            <tr>
                                <td>{{ $address->id }}</td>
                                <td>{{ $address->address }}</td>
                                <td>
                                    @if($address->user)
                                            {{ $address->user->name }}
                                    @else
                                        <span class="text-muted">No user</span>
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-danger" wire:click="confirmDelete({{ $address->id }})">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
            <div class="card-footer clearfix pagination-container">
                <div class="w-100">
                    {{ $addresses->links() }}
                </div>
            </div>
            </div>
        </div>
    </div>

    <!-- Add Addresses Modal -->
    @if($showAddModal)
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Addresses</h5>
                    <button type="button" class="close" wire:click="$set('showAddModal', false)">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Addresses (one per line)</label>
                        <textarea class="form-control" wire:model="newAddresses" rows="10" placeholder="Enter addresses, one per line"></textarea>
                        @error('newAddresses') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="$set('showAddModal', false)">Cancel</button>
                    <button type="button" class="btn btn-primary" wire:click="addAddresses">Add Addresses</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Delete Confirmation Modal -->
    @if($showDeleteModal)
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Address</h5>
                    <button type="button" class="close" wire:click="$set('showDeleteModal', false)">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this address? This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="$set('showDeleteModal', false)">Cancel</button>
                    <button type="button" class="btn btn-danger" wire:click="deleteAddress">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif
</div>

@if (session()->has('message'))
    <div class="alert alert-success">
        {{ session('message') }}
    </div>
@endif
