<div class="container-fluid mtb15 no-fluid">
    <div class="row sm-gutters">
      <div class="col-md-3">
        <div class="market-pairs">
          <div class="input-group">
            <div class="input-group-prepend">
              <span class="input-group-text" id="inputGroup-sizing-sm"><i class="icon ion-md-search"></i></span>
            </div>
            <input type="text" class="form-control" placeholder="Search" aria-describedby="inputGroup-sizing-sm">
          </div>
          @if(empty($search))
          <ul class="nav nav-pills" role="tablist">
            @foreach ($currencyTypes as $currencyType)
              <li class="nav-item">
                @if ($currencyType->code == $currentCurrencyTypeCode)
                  <a class="nav-link active" data-toggle="pill" href="#{{$currencyType->code}}" role="tab" aria-selected="true" wire:click="clickCurrencyType('{{$currencyType->code}}')">{{$currencyType->name}}</a>
                @else
                  <a class="nav-link" data-toggle="pill" href="#{{$currencyType->code}}" role="tab" aria-selected="true" wire:click="clickCurrencyType('{{$currencyType->code}}')">{{$currencyType->name}}</a>
                @endif
              </li>
            @endforeach
          </ul>
          @endif
          <div class="tab-content">
            @if(!empty($search))
              <div class="table-responsive">
                <table class="table">
                  <thead>
                    <tr>
                      <th>Symbol</th>
                      <th>Bid</th>
                      <th>Ask</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($filteredCurrencies as $currency)
                      <tr wire:click="clickCurrency({{$currency->id}})" class="currency-row">
                        <td width="40%">
                          @if($currency->iconExists())
                              <img src="{{$currency->getIconUrl()}}" class="asset-image {{$currency->type->code}}"/>
                          @else
                              <div class="containera">
                                  <span class="responsive_headline">{{$currency->name[0]}}</span>
                              </div>
                          @endif
                          <span>{{$currency->name}}</span>
                        </td>
                        
                        <td width="40%" class="{{ $currency->has_bid_changed ? ($currency->old_bid < $currency->bid ? 'price-up' : 'price-down') : '' }}">{{$currency->formatted_bid}}</td>
                        <td width="40%" class="{{ $currency->has_ask_changed ? ($currency->old_ask < $currency->ask ? 'price-up' : 'price-down') : '' }}">{{$currency->formatted_ask}}</td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            @else
              @foreach ($currencyTypes as $currencyType)
                @if($currencyType->code == $currentCurrencyTypeCode)
                  <div class="tab-pane fade show active" id="{{$currencyType->code}}" role="tabpanel">
                @else
                  <div class="tab-pane fade show" id="{{$currencyType->code}}" role="tabpanel">
                @endif
                  <div class="table-responsive">
                    <table class="table">
                      <thead>
                        <tr>
                          <th>Symbol</th>
                          <th>Bid</th>
                          <th>Ask</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach ($currencyType->currencies as $currency)
                          <tr wire:click="clickCurrency({{$currency->id}})" class="currency-row">
                            <td width="40%">
                              @if($currency->iconExists())
                                  <img src="{{$currency->getIconUrl()}}" class="asset-image {{$currency->type->code}}"/>
                              @else
                                  <div class="containera">
                                      <span class="responsive_headline">{{$currency->name[0]}}</span>
                                  </div>
                              @endif
                              <span>{{$currency->name}}</span>
                            </td>
                            <td width="40%">
                              <livewire:real-time-property :model="$currency" :property="'formatted_bid'" :showClass="'bid-price'" wire:key="bid-{{$currency->id}}"/>
                            </td>
                            <td width="40%">
                              <livewire:real-time-property :model="$currency" :property="'formatted_ask'" :showClass="'ask-price'" wire:key="ask-{{$currency->id}}"/>
                            </td>
                          </tr>
                        @endforeach
                      </tbody>
                    </table>
                  </div>
                </div>
              @endforeach
            @endif
          </div>
        </div>
      </div>
      <div class="col-12 col-md-7">
        <div class="main-chart dark-variant">
          <!-- TradingView Widget BEGIN -->
          <div class="tradingview-widget-container">
            <div id="tradingview_e8033" style="height: 100%;" wire:ignore></div>
          </div>
          <!-- TradingView Widget END -->
        </div>
        
        <div class="market-history market-order">
          <ul class="nav nav-pills" role="tablist" wire:ignore>
            <li class="nav-item">
              <a class="nav-link {{ $this->currentTab === 'open-orders' ? 'active' : '' }}" 
                 data-toggle="pill" 
                 href="#open-orders" 
                 role="tab" 
                 aria-selected="{{ $this->currentTab === 'open-orders' ? 'true' : 'false' }}"
                 wire:click="switchTab('open-orders')">
                Open Orders
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link {{ $this->currentTab === 'closed-orders' ? 'active' : '' }}" 
                 data-toggle="pill" 
                 href="#closed-orders" 
                 role="tab" 
                 aria-selected="{{ $this->currentTab === 'closed-orders' ? 'true' : 'false' }}"
                 wire:click="switchTab('closed-orders')">
                Closed Orders
              </a>
            </li>
          </ul>
          <div class="tab-content">
            <div class="tab-pane fade {{ $this->currentTab === 'open-orders' ? 'show active' : '' }}" 
                 id="open-orders" 
                 role="tabpanel">
              <div class="orders-container">
                <div class="card-body table-responsive p-0">
                  <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>Symbol</th>
                            <th>Type</th>
                            <th>Volume</th>
                            <th>Open Price</th>
                            <th>Current Price</th>
                            <th>Take Profit</th>
                            <th>Stop Loss</th>
                            <th>Open Time</th>
                            <th>P/L</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($openOrders as $order)
                            <tr>
                                <td class="order-currency">
                                  @if($order->currency->iconExists())
                                      <img src="{{$order->currency->getIconUrl()}}" class="asset-image {{$order->currency->type->code}}"/>
                                  @else
                                      <div class="containera">
                                          <span class="responsive_headline">{{$order->currency->name[0]}}</span>
                                      </div>
                                  @endif
                                  {{ $order->currency->name }}
                                </td>
                                <td>
                                    <div class="text-left {{ $order->side === 'buy' ? 'text-success' : 'text-danger' }}" style="flex: 1;">{{ strtoupper($order->side) }}</div>
                                </td>
                                <td>{{ $order->formatted_volume }}</td>
                                <td>{{ $order->formatted_open_price }}</td>
                                <td>
                                  @if($order->side == 'buy')
                                    <livewire:real-time-property :model="$order->currency" property="formatted_bid" wire:key="order-bid-{{$order->id}}"/>
                                  @else
                                    <livewire:real-time-property :model="$order->currency" property="formatted_ask" wire:key="order-ask-{{$order->id}}"/>
                                  @endif
                                </td>
                                <td>
                                @if(!$order->take_profit)
                                <button class="btn btn-sm btn-primary btn-take-profit" wire:click="openTakeProfitModal({{ $order->id }})">
                                  Add TP
                                </button>
                                @else
                                  {{ $order->formatted_take_profit }}
                                @endif
                                </td>
                                <td>
                                  @if(!$order->stop_loss)
                                    <button class="btn btn-sm btn-danger btn-stop-loss" wire:click="openStopLossModal({{ $order->id }})">
                                      Add SL
                                    </button>
                                  @else
                                    {{ $order->formatted_stop_loss }}
                                  @endif
                                </td>
                                <td>
                                  {{ $order->created_at ? $order->created_at->format('Y-m-d H:i') : '-' }}
                                </td>
                                <td>
                                  <livewire:real-time-property :model="$order" property="getFormattedPl" :showClass="'order-pl'" wire:key="order-pl-{{$order->id}}"/>
                                </td>
                                <td>
                                  <button class="btn btn-sm btn-primary btn-close-order" wire:click="confirmCloseOrder({{ $order->id }})">
                                    Close
                                  </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="10" class="text-center">No orders found</td>
                            </tr>
                        @endforelse
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="tab-pane fade {{ $this->currentTab === 'closed-orders' ? 'show active' : '' }}" 
                 id="closed-orders" 
                 role="tabpanel">
              <div class="orders-container" style="max-height: 300px; overflow-y: auto;">
              <div class="card-body table-responsive p-0">
                  <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>Symbol</th>
                            <th>Type</th>
                            <th>Volume</th>
                            <th>Open Price</th>
                            <th>Close Price</th>
                            <th>Take Profit</th>
                            <th>Stop Loss</th>
                            <th>Open Time</th>
                            <th>Close Time</th>
                            <th>P/L</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($closedOrders as $closedOrder)
                            <tr>
                                <td class="order-currency">
                                  @if($closedOrder->currency->iconExists())
                                      <img src="{{$closedOrder->currency->getIconUrl()}}" class="asset-image {{$closedOrder->currency->type->code}}"/>
                                  @else
                                      <div class="containera">
                                          <span class="responsive_headline">{{$closedOrder->currency->name[0]}}</span>
                                      </div>
                                  @endif
                                  {{ $closedOrder->currency->name }}
                                </td>
                                <td>
                                    <div class="text-left {{ $closedOrder->side === 'buy' ? 'text-success' : 'text-danger' }}" style="flex: 1;">{{ strtoupper($closedOrder->side) }}</div>
                                </td>
                                <td>{{ $closedOrder->formatted_volume }}</td>
                                <td>{{ $closedOrder->formatted_open_price }}</td>
                                <td>
                                  {{ $closedOrder->formatted_close_price }}
                                </td>
                                <td>
                                  {{ $closedOrder->formatted_take_profit }}
                                </td>
                                <td>
                                  {{ $closedOrder->formatted_stop_loss }}
                                </td>
                                <td>
                                  {{ $closedOrder->created_at ? $closedOrder->created_at->format('Y-m-d H:i') : '-' }}
                                </td>
                                <td>
                                  {{ $closedOrder->close_time ? $closedOrder->close_time->format('Y-m-d H:i') : '-' }}
                                </td>
                                <td>
                                  <span class="{{ $closedOrder->getPLStatus() }}">{{ $closedOrder->getFormattedPL() }}</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="10" class="text-center">No orders found</td>
                            </tr>
                        @endforelse
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-md-2">
        <div class="market-trade">
          <div class="card-title market-trade-header col-md-12">
            @if($currentCurrency->iconExists())
                <img src="{{$currentCurrency->getIconUrl()}}" class="asset-image {{$currentCurrency->type->code}}"/>
            @else
                <div class="containera">
                    <span class="responsive_headline">{{$currentCurrency->name[0]}}</span>
                </div>
            @endif
            <span>{{$currentCurrency->name}}</span>
          </div>
          <div class="market-trade-content col-md-12" id="pills-trade-limit">
            <div class="d-flex justify-content-between">
              <div class="market-trade-buy">
                <button class="btn buy {{ $orderType === 'buy' ? 'selected' : '' }}" wire:click="clickOrderTypeButton('buy')">
                  <span>Buy @</span> <livewire:real-time-property :model="$currentCurrency" property="formatted_bid" wire:key="order-bid-{{$currentCurrency->id}}"/>
                </button>
              </div>
              <div class="market-trade-sell">
                <button type="submit" class="btn sell {{ $orderType === 'sell' ? 'selected' : '' }}" wire:click="clickOrderTypeButton('sell')">
                  <span>Sell @</span> <livewire:real-time-property :model="$currentCurrency" property="formatted_ask" wire:key="order-ask-{{$currentCurrency->id}}"/>
                </button>
              </div>
            </div>
          
          <div class="market-trade-form">
              <div class="input-group">
                <input type="number" 
                       class="form-control" 
                       placeholder="Volume" 
                       required 
                       wire:model.live="volume" 
                       step="0.1" 
                       min="0.1" />
                <div class="input-group-append">
                  <span class="input-group-text">Lots</span>
                  <button class="btn btn-outline-secondary" type="button" wire:click="decrementVolume">-</button>
                  <button class="btn btn-outline-secondary" type="button" wire:click="incrementVolume">+</button>
                </div> 
              </div>
              @if($orderType && $this->margin > auth()->user()->calculateFreeMargin())
                <div class="text-danger">
                  Insufficient free margin.
                </div>
              @endif

              <div class="input-group">
                <input type="number" 
                       class="form-control" 
                       placeholder="Take Profit" 
                       step="0.01" 
                       wire:model.live="takeProfit"
                       oninput="this.value = Math.max(this.value, this.min)"/>
                <div class="input-group-append">
                  <span class="input-group-text">Price</span>
                  <button class="btn btn-outline-secondary" type="button" wire:click="decrementTakeProfit">-</button>
                  <button class="btn btn-outline-secondary" type="button" wire:click="incrementTakeProfit">+</button>
                </div> 
              </div>
              @if($orderType)
                @if($orderType === 'buy' && $takeProfit && $takeProfit <= $currentCurrency->ask)
                  <div class="text-danger">
                    Min <livewire:real-time-property :model="$currentCurrency" property="formatted_ask" wire:key="order-take-profit-min-ask-{{$currentCurrency->id}}"/>
                  </div>
                @endif
                @if($orderType === 'sell' && $takeProfit && $takeProfit >= $currentCurrency->bid)
                  <div class="text-danger">
                    Max <livewire:real-time-property :model="$currentCurrency" property="formatted_bid" wire:key="order-take-profit-max-bid-{{$currentCurrency->id}}"/>
                  </div>
                @endif
              @endif

              <div class="input-group">
                <input type="number" class="form-control" placeholder="Stop Loss" step="0.01" wire:model.live="stopLoss" />
                <div class="input-group-append">
                  <span class="input-group-text">Price</span>
                  <button class="btn btn-outline-secondary" type="button" wire:click="decrementStopLoss">-</button>
                  <button class="btn btn-outline-secondary" type="button" wire:click="incrementStopLoss">+</button>
                </div> 
              </div>
              @if($orderType)
                @if($orderType === 'buy' && $stopLoss && $stopLoss >= $currentCurrency->ask)
                  <div class="text-danger">
                    Max <livewire:real-time-property :model="$currentCurrency" property="formatted_ask" wire:key="order-stop-loss-max-ask-{{$currentCurrency->id}}"/>
                  </div>
                @endif
                @if($orderType === 'sell' && $stopLoss && $stopLoss <= $currentCurrency->bid)
                  <div class="text-danger">
                    Min <livewire:real-time-property :model="$currentCurrency" property="formatted_bid" wire:key="order-stop-loss-min-bid-{{$currentCurrency->id}}"/>
                  </div>
                @endif
              @endif

              @if ($orderType)
                <div class="d-flex flex-column gap-2">
                  <button class="btn {{$orderType}} selected" wire:click="clickConfirmOrder()" @if(!$this->canPlaceOrder()) disabled @endif>
                    Confirm {{$orderType}} {{ $volume }} lots
                  </button>
                  <button class="btn btn-outline-secondary mt-2" wire:click="clickOrderTypeButton('')">
                    Cancel
                  </button>
                </div>
              @endif
            </div>
            @if($orderType)
            <div class="market-trade-summary mt-3">
              <div class="d-flex justify-content-between">
                <span>Fees:</span>
                <span>
                  ≈ ${{ number_format($this->fees, 2) }}
                </span>
              </div>
              <div class="d-flex justify-content-between">
                <span>Leverage:</span>
                <span>1:{{ $currentCurrency->leverage }}</span>
              </div>
              <div class="d-flex justify-content-between">
                <span>Required Margin:</span>
                <span>${{ number_format($this->margin, 2) }}</span>
              </div>
              <div class="more-details" @if($showMoreDetails) style="display: block;" @else style="display: none;" @endif>
                <div class="d-flex justify-content-between">
                  <span>Pip Value:</span>
                  <span>${{ number_format($this->pipValue, 2) }}</span>
                </div>
                <div class="d-flex justify-content-between">
                  <span>Volume (Units):</span>
                  <span>{{ number_format($this->volumeInUnits, 2) }} {{ $currentCurrency->code }}</span>
                </div>
                <div class="d-flex justify-content-between">
                  <span>Volume (USD):</span>
                  <span>${{ number_format($this->volumeInUsd, 2) }}</span>
                </div>
              </div>
              <div class="text-left my-2">
                <button class="btn btn-sm btn-outline-secondary" wire:click="$toggle('showMoreDetails')">
                  {{ $showMoreDetails ? 'Less' : 'More' }}
                </button>
              </div>
            </div>
            @endif
        </div>
      </div>
      <div class="col-md-3">
      </div>
      <div class="col-md-9">
      </div>
    </div>
  </div>
    @script
    <script>
        // document.addEventListener('livewire:initialized', () => {
            // Initialize the first chart
            initializeTradingViewChart(@js($this->currentCurrency->chart_code));
            
            $wire.on('currency-changed', (event) => {
                initializeTradingViewChart(event.currentCurrency.chart_code);
            });

            // Remove tab parameter from URL when currency is selected from market tab
            $wire.on('remove-tab-parameter', () => {
                const url = new URL(window.location);
                url.searchParams.delete('tab');
                window.history.pushState({}, '', url);
                // Update footer active state
                if (typeof updateFooterActiveTab === 'function') {
                    updateFooterActiveTab();
                }
            });
        // });

        function initializeTradingViewChart(symbol) {
            // Initialize new widget
            window.tradingViewWidget = new TradingView.widget({
                    "width": "100%",
                    "height": 550,
                    "symbol": symbol,
                    "interval": "D",
                    "timezone": "Etc/UTC",
                    "theme": "dark",
                    "style": "3",
                    "locale": "en",
                    "toolbar_bg": "#f1f3f6",
                    "enable_publishing": false,
                    "withdateranges": true,
                    "hide_side_toolbar": false,
                    "allow_symbol_change": true,
                    "show_popup_button": true,
                    "popup_width": "1000",
                    "popup_height": "650",
                    "hide_volume": true,
                    "container_id": "tradingview_e8033",
                    "loading_screen": {
                        "backgroundColor": "transparent"
                    },
                    "overrides": {
                        "paneProperties.backgroundGradientStartColor": "#020024",
                        "paneProperties.backgroundGradientEndColor": "#4f485e",
                    },
                });
        }
    </script>
    @endscript

<!-- Take Profit / Stop Loss Modal -->
@if($selectedOrder)
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog"  data-bs-theme="dark">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          @if($modalType == 'take_profit')
            Set Take Profit for {{ $selectedOrder->currency->name }}
          @else
            Set Stop Loss for {{ $selectedOrder->currency->name }}
          @endif
        </h5>
        <button type="button" class="close" wire:click="closeModal">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label for="price">
            @if($modalType == 'take_profit')
              Take Profit Price
            @else
              Stop Loss Price
            @endif
          </label>
          <div class="input-group">
            <input type="number" 
                   class="form-control" 
                   id="price" 
                   wire:model="{{ $modalType == 'take_profit' ? 'newTakeProfit' : 'newStopLoss' }}" 
                   step="0.01" 
                   min="0">
            <div class="input-group-append">
              <span class="input-group-text">USD</span>
            </div>
          </div>
          
          @if($selectedOrder->side === 'buy' && $newTakeProfit && $newTakeProfit <= $selectedOrder->currency->ask)
            <div class="text-danger">
              Min {{ $selectedOrder->currency->formatted_ask }}
            </div>
          @endif
          @if($selectedOrder->side === 'sell' && $newTakeProfit && $newTakeProfit >= $selectedOrder->currency->bid)
            <div class="text-danger">
              Max {{ $selectedOrder->currency->formatted_bid }}
            </div>
          @endif
          
          @if($selectedOrder->side === 'buy' && $newStopLoss && $newStopLoss >= $selectedOrder->currency->ask)
            <div class="text-danger">
              Max {{ $selectedOrder->currency->formatted_ask }}
            </div>
          @endif
          @if($selectedOrder->side === 'sell' && $newStopLoss && $newStopLoss <= $selectedOrder->currency->bid)
            <div class="text-danger">
              Min {{ $selectedOrder->currency->formatted_bid }}
            </div>
          @endif
          
          @if($modalType == 'take_profit')
            @error('newTakeProfit') <span class="text-danger">{{ $message }}</span> @enderror
          @else
            @error('newStopLoss') <span class="text-danger">{{ $message }}</span> @enderror
          @endif
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
        <button type="button" class="btn btn-primary" wire:click="{{ $modalType == 'take_profit' ? 'updateTakeProfit' : 'updateStopLoss' }}" @if(!$this->canUpdateSelectedOrder()) disabled @endif>
          Save
        </button>
      </div>
    </div>
  </div>
</div>
<div class="modal-backdrop fade show"></div>
@endif

<!-- Close Order Confirmation Modal -->
@if($showCloseOrderModal)
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Confirm Close Order</h5>
        <button type="button" class="close" wire:click="cancelCloseOrder">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>Are you sure you want to close this order?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" wire:click="cancelCloseOrder">Cancel</button>
        <button type="button" class="btn btn-danger" wire:click="closeOrderConfirmed">Close Order</button>
      </div>
    </div>
  </div>
</div>
<div class="modal-backdrop fade show"></div>
@endif

<!-- Edit Order Modal -->
@if($showEditOrderModal)
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog" data-bs-theme="dark">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          Edit Order - {{ $editingOrder->currency->name }}
        </h5>
        <button type="button" class="close" wire:click="closeEditOrderModal">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label for="editTakeProfit">Take Profit</label>
          <div class="input-group">
            <input type="number" 
                   class="form-control" 
                   id="editTakeProfit" 
                   wire:model.live="editTakeProfit" 
                   step="0.01" 
                   min="0">
            <div class="input-group-append">
              <span class="input-group-text">USD</span>
            </div>
          </div>
          
          
          @if($editingOrder->side === 'buy' && $editTakeProfit && $editTakeProfit <= $editingOrder->currency->ask)
            <div class="text-danger">
              Min {{ $editingOrder->currency->formatted_ask }}
            </div>
          @endif
          @if($editingOrder->side === 'sell' && $editTakeProfit && $editTakeProfit >= $editingOrder->currency->bid)
            <div class="text-danger">
              Max {{ $editingOrder->currency->formatted_bid }}
            </div>
          @endif

        <div class="form-group">
          <label for="editStopLoss">Stop Loss</label>
          <div class="input-group">
            <input type="number" 
                   class="form-control" 
                   id="editStopLoss" 
                   wire:model.live="editStopLoss" 
                   step="0.01" 
                   min="0">
            <div class="input-group-append">
              <span class="input-group-text">USD</span>
            </div>
          </div>
          @if($editingOrder->side === 'buy' && $editStopLoss && $editStopLoss >= $editingOrder->currency->ask)
            <div class="text-danger">
              Max {{ $editingOrder->currency->formatted_ask }}
            </div>
          @endif
          @if($editingOrder->side === 'sell' && $editStopLoss && $editStopLoss <= $editingOrder->currency->bid)
            <div class="text-danger">
              Min {{ $editingOrder->currency->formatted_bid }}
            </div>
          @endif
        </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" wire:click="closeEditOrderModal">Cancel</button>
        <button type="button" class="btn btn-primary" wire:click="updateOrder" @if(!$this->canUpdateOrder()) disabled @endif>Save changes</button>
      </div>
    </div>
  </div>
</div>
<div class="modal-backdrop fade show"></div>
@endif
</div>