@extends('layouts.app')

@section('content')
<div class="vh-100 d-flex justify-content-center">
    <div class="form-access my-auto">
        <form method="POST" action="{{ route('register') }}">
            @csrf
            <span>Create Account</span>
            
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="form-group">
                <input type="text" class="form-control" name="name" placeholder="Full Name" value="{{ old('name') }}" required>
            </div>
            <div class="form-group">
                <input type="email" class="form-control" name="email" placeholder="Email Address" value="{{ old('email') }}" required>
            </div>
            <div class="form-group">
                <input type="password" class="form-control" name="password" placeholder="Password" required>
            </div>
            <div class="form-group">
                <input type="password" class="form-control" name="password_confirmation" placeholder="Confirm Password" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="phone_number" placeholder="Phone Number" value="{{ old('phone_number') }}" required>
            </div>
            <div class="form-group">
                <input type="date" class="form-control" name="date_of_birth" placeholder="Date of Birth" value="{{ old('date_of_birth') }}" required>
            </div>
            <div class="form-group">
                <input type="text" class="form-control @error('promo_code') is-invalid @enderror" name="promo_code" placeholder="Promo Code" value="{{ old('promo_code') }}" required>
            </div>
            <button type="submit" class="btn btn-primary">Create Account</button>
            <h2>Already have an account? <a href="{{ route('login') }}">Sign in here</a></h2>
        </form>
    </div>
</div>
@endsection