<div class="container-fluid px-4">
    <!--[if BLOCK]><![endif]--><?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <i class="icon ion-md-cash mr-1"></i>
                    Deposit & Withdraw Transactions
                </div>
                <!--[if BLOCK]><![endif]--><?php if(Auth::user()->hasRole('admin')): ?>
                <button wire:click="openCreateModal" class="btn btn-primary btn-sm">
                    <i class="icon ion-md-add mr-1"></i> Create Transaction
                </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>To Address</th>
                            <th>Date</th>
                            <th>Status</th>
                            <!--[if BLOCK]><![endif]--><?php if(Auth::user()->hasRole('admin')): ?>
                            <th>Action</th>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($transaction->id); ?></td>
                            <td><?php echo e($transaction->user->name); ?> (<?php echo e($transaction->user->email); ?>)</td>
                            <td><?php echo e(ucfirst($transaction->type)); ?></td>
                            <td><?php echo e($transaction->description); ?></td>
                            <td><?php echo e(rtrim(rtrim(number_format($transaction->amount, 8), '0'), '.')); ?></td>
                            <td><?php echo e($transaction->to_address ?? 'N/A'); ?></td>
                            <td><?php echo e($transaction->created_at ? $transaction->created_at->format('Y-m-d H:i:s') : '-'); ?></td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if($transaction->confirmed): ?>
                                    <span class="badge badge-success">Confirmed</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <!--[if BLOCK]><![endif]--><?php if(Auth::user()->hasRole('admin')): ?>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if(!$transaction->confirmed && ($transaction->type == 'deposit' || $transaction->type == 'withdraw')): ?>
                                <div class="d-flex gap-1">
                                    <button wire:click="confirmTransaction(<?php echo e($transaction->id); ?>)" class="btn btn-success btn-sm mr-2" onclick="return confirm('Are you sure you want to confirm this transaction?')">Confirm</button>
                                    <button wire:click="declineTransaction(<?php echo e($transaction->id); ?>)" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to decline this transaction? This will delete it from the database.')">Decline</button>
                                </div>
                                <?php else: ?>
                                    -
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center">No transactions found.</td>
                        </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer clearfix pagination-container">
            <div class="w-100">
                <?php echo e($transactions->links()); ?>

            </div>
        </div>
    </div>

    <!-- Create Transaction Modal -->
    <!--[if BLOCK]><![endif]--><?php if(Auth::user()->hasRole('admin')): ?>
    <!--[if BLOCK]><![endif]--><?php if($showCreateModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create New Transaction</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form wire:submit.prevent="createTransaction">
                        <div class="form-group mb-3">
                            <label for="user_id">User</label>
                            <select class="form-control <?php $__errorArgs = ['newTransaction.user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="user_id" 
                                    wire:model="newTransaction.user_id">
                                <option value="">Select User</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTransaction.user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="form-group mb-3">
                            <label for="type">Transaction Type</label>
                            <select class="form-control <?php $__errorArgs = ['newTransaction.type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="type" 
                                    wire:model.live="newTransaction.type">
                                <option value="deposit">Deposit</option>
                                <option value="withdraw">Withdraw</option>
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTransaction.type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="form-group mb-3">
                            <label for="amount">Amount</label>
                            <input type="number" 
                                   class="form-control <?php $__errorArgs = ['newTransaction.amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="amount" 
                                   wire:model="newTransaction.amount"
                                   step="0.00000001"
                                   min="0">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTransaction.amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="form-group mb-3">
                            <label for="description">Description</label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['newTransaction.description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="description" 
                                   wire:model="newTransaction.description">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTransaction.description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!--[if BLOCK]><![endif]--><?php if($newTransaction['type'] === 'withdraw'): ?>
                        <div class="form-group mb-3">
                            <label for="to_address">To Address</label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['newTransaction.to_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="to_address" 
                                   wire:model="newTransaction.to_address">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTransaction.to_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Create Transaction</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home/viktorion/public_html/webtrader/resources/views/livewire/admin-transactions.blade.php ENDPATH**/ ?>