<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="mb-3">
                        <i class="icon ion-md-map mr-1"></i>
                        Addresses Management
                    </div>
                    
                    <ul class="nav nav-pills card-header-pills">
                        
                        <li class="nav-item mr-5">
                            
                        <div class="input-group" style="width: 250px;">
                            <input type="text" wire:model.live="search" class="form-control float-right" placeholder="Search...">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link active" wire:click="$set('showAddModal', true)">Add Addresses</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th wire:click="sortBy('id')" style="cursor: pointer;">
                                    ID
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'id'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </th>
                                <th wire:click="sortBy('address')" style="cursor: pointer;">
                                    Address
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'address'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </th>
                                <th wire:click="sortBy('user_id')" style="cursor: pointer;">
                                    User
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'user_id'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($address->id); ?></td>
                                <td><?php echo e($address->address); ?></td>
                                <td>
                                    <!--[if BLOCK]><![endif]--><?php if($address->user): ?>
                                            <?php echo e($address->user->name); ?>

                                    <?php else: ?>
                                        <span class="text-muted">No user</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-danger" wire:click="confirmDelete(<?php echo e($address->id); ?>)">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>
                
            <div class="card-footer clearfix pagination-container">
                <div class="w-100">
                    <?php echo e($addresses->links()); ?>

                </div>
            </div>
            </div>
        </div>
    </div>

    <!-- Add Addresses Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showAddModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Addresses</h5>
                    <button type="button" class="close" wire:click="$set('showAddModal', false)">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Addresses (one per line)</label>
                        <textarea class="form-control" wire:model="newAddresses" rows="10" placeholder="Enter addresses, one per line"></textarea>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newAddresses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="$set('showAddModal', false)">Cancel</button>
                    <button type="button" class="btn btn-primary" wire:click="addAddresses">Add Addresses</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Delete Confirmation Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showDeleteModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Address</h5>
                    <button type="button" class="close" wire:click="$set('showDeleteModal', false)">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this address? This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="$set('showDeleteModal', false)">Cancel</button>
                    <button type="button" class="btn btn-danger" wire:click="deleteAddress">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>

<!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
    <div class="alert alert-success">
        <?php echo e(session('message')); ?>

    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php /**PATH /Users/indrit.rexhepi/Downloads/webtrader-new/resources/views/livewire/admin-addresses.blade.php ENDPATH**/ ?>