<?php

namespace App\Livewire\Profile;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class General extends Component
{
    public $name;
    public $email;

    protected function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . Auth::id(),
        ];
    }

    public function mount()
    {
        $user = Auth::user();
        $this->name = $user->name;
        $this->email = $user->email;
    }

    public function updated($propertyName)
    {
        if ($propertyName === 'email') {
            $this->rules['email'] = 'required|string|email|max:255|unique:users,email,' . Auth::id();
        }
        $this->validateOnly($propertyName);
    }

    public function save()
    {
        $this->validate();

        $user = Auth::user();
        $updateData = [
            'name' => $this->name,
            'email' => $this->email,
        ];

        $user->update($updateData);

        session()->flash('message', 'Profile updated successfully.');
        $this->dispatch('profile-updated');
    }

    public function render()
    {
        return view('livewire.profile.general');
    }
} 