<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        // Create admin user
        $admin = User::create([
            'name' => 'Admin',
            'email' => 'admin@trade.com',
            'password' => Hash::make('adminTRADE@1'),
            'login' => '10000',
            'currency' => 'USD',
            'balance' => 0,
            'leverage' => 100,
            'credit' => 0,
            'margin' => 0,
            'free_margin' => 0,
            'margin_level' => 0,
        ]);

        // Attach admin role
        $adminRole = Role::where('name', 'admin')->first();
        $admin->roles()->attach($adminRole);
    }
} 