<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ env('APP_NAME') }}</title>
    <link rel="icon" href="/assets/img/favicon.png" type="image/x-icon">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <meta name="csrf_token" value="{{ csrf_token() }}"/>
    @livewireStyles
</head>
<body id="dark">
    <header class="dark-bb">
        <nav class="navbar navbar-expand-lg fixed-top">
            <a class="navbar-brand" href="/"><img src="/assets/img/logo-light.png" alt="logo"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#headerMenu"
                aria-controls="headerMenu" aria-expanded="false" aria-label="Toggle navigation">
                <i class="icon ion-md-menu"></i>
            </button>

            <div class="collapse navbar-collapse" id="headerMenu">
                <ul class="navbar-nav mr-auto">
                </ul>
                <ul class="navbar-nav ml-auto">
                    
                    @auth
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="#" id="disabledIconsDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img src="/assets/img/icon/menu.png" alt="Menu" width="28" height="28">
                        </a>
                        <div class="dropdown-menu p-4" aria-labelledby="disabledIconsDropdown" style="min-width:300px; right: 8px;">
                            <div class="row">
                                <div class="col-md-6 p-3">
                                <div class="text-center m-2" style="cursor: not-allowed;">
                                    <img src="/assets/img/icon/staking.png" class="img-fluid mb-3" alt="Staking" width="40" height="40" style="filter: grayscale(1) opacity(0.5); cursor: not-allowed;">
                                    <div style="color: #aaa; font-size: 14px;">Staking</div>
                                </div>
                                </div>
                                <div class="col-md-6 p-3">
                                <div class="text-center m-2" style="cursor: not-allowed;">
                                    <img src="/assets/img/icon/copy-trading.png" class="img-fluid mb-3" alt="Copy Trading" width="40" height="40" style="filter: grayscale(1) opacity(0.5); cursor: not-allowed;">
                                    <div style="color: #aaa; font-size: 14px;">Copy Trading</div>
                                </div>
                                </div>
                                <div class="col-md-6 p-3">
                                    <div class="text-center m-2" style="cursor: not-allowed;">
                                        <img src="/assets/img/icon/portfolio.png" class="img-fluid mb-3" alt="Portfolio" width="40" height="40" style="filter: grayscale(1) opacity(0.5); cursor: not-allowed;">
                                        <div style="color: #aaa; font-size: 14px;">Portfolio</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    
                    <li class="nav-item mt-1">
                        <a class="nav-link btn btn-secondary" href="{{ route('wallet') }}">Wallet</a>
                    </li>
                    @if(Auth::user()->hasRole('admin'))
                        <li class="nav-item mt-1">
                            <a class="nav-link" href="{{ route('admin.dashboard') }}">Admin</a>
                        </li>
                    @elseif(Auth::user()->hasRole('manager'))
                        <li class="nav-item mt-1">
                            <a class="nav-link" href="{{ route('admin.dashboard') }}">CRM</a>
                        </li>
                    @endif
                    <li class="nav-item dropdown header-img-icon">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">
                            <img src="/assets/img/icon/profile.png" alt="avatar">
                        </a>
                        <x-user-dropdown />
                    </li>
                    @endauth
                    @guest
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('register') }}">Sign Up</a>
                    </li>
                    @endguest
                </ul>
            </div>
        </nav>
    </header>

    <main>
        @yield('content')
    </main>
    
    @livewire('footer')

    <script src="/assets/js/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/popper.min.js"></script>
    <script src="/assets/js/bootstrap.min.js"></script>
    <script src="/assets/js/amcharts-core.min.js"></script>
    <script src="/assets/js/amcharts.min.js"></script>
    <script src="/assets/js/custom.js"></script>
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    @livewireScripts
    <script>
        window.addEventListener('alert', event => {
             toastr[event.detail[0].type](event.detail[0].message, event.detail[0].title ?? '')
             toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-bottom-right",
            }
        });
    </script>
</body>
</html> 