<div class="container-fluid px-4">
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <i class="icon ion-md-cash mr-1"></i>
                    Deposit & Withdraw Transactions
                </div>
                @if(Auth::user()->hasRole('admin'))
                <button wire:click="openCreateModal" class="btn btn-primary btn-sm">
                    <i class="icon ion-md-add mr-1"></i> Create Transaction
                </button>
                @endif
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>To Address</th>
                            <th>Date</th>
                            <th>Status</th>
                            @if(Auth::user()->hasRole('admin'))
                            <th>Action</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                        <tr>
                            <td>{{ $transaction->id }}</td>
                            <td>{{ $transaction->user->name }} ({{ $transaction->user->email }})</td>
                            <td>{{ ucfirst($transaction->type) }}</td>
                            <td>{{ $transaction->description }}</td>
                            <td>{{ rtrim(rtrim(number_format($transaction->amount, 8), '0'), '.') }}</td>
                            <td>{{ $transaction->to_address ?? 'N/A' }}</td>
                            <td>{{ $transaction->created_at ? $transaction->created_at->format('Y-m-d H:i:s') : '-' }}</td>
                            <td>
                                @if($transaction->confirmed)
                                    <span class="badge badge-success">Confirmed</span>
                                @else
                                    <span class="badge badge-warning">Pending</span>
                                @endif
                            </td>
                            @if(Auth::user()->hasRole('admin'))
                            <td>
                                @if(!$transaction->confirmed && ($transaction->type == 'deposit' || $transaction->type == 'withdraw'))
                                <div class="d-flex gap-1">
                                    <button wire:click="confirmTransaction({{ $transaction->id }})" class="btn btn-success btn-sm mr-2" onclick="return confirm('Are you sure you want to confirm this transaction?')">Confirm</button>
                                    <button wire:click="declineTransaction({{ $transaction->id }})" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to decline this transaction? This will delete it from the database.')">Decline</button>
                                </div>
                                @else
                                    -
                                @endif
                            </td>
                            @endif
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center">No transactions found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer clearfix pagination-container">
            <div class="w-100">
                {{ $transactions->links() }}
            </div>
        </div>
    </div>

    <!-- Create Transaction Modal -->
    @if(Auth::user()->hasRole('admin'))
    @if($showCreateModal)
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create New Transaction</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form wire:submit.prevent="createTransaction">
                        <div class="form-group mb-3">
                            <label for="user_id">User</label>
                            <select class="form-control @error('newTransaction.user_id') is-invalid @enderror" 
                                    id="user_id" 
                                    wire:model="newTransaction.user_id">
                                <option value="">Select User</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                                @endforeach
                            </select>
                            @error('newTransaction.user_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="form-group mb-3">
                            <label for="type">Transaction Type</label>
                            <select class="form-control @error('newTransaction.type') is-invalid @enderror" 
                                    id="type" 
                                    wire:model.live="newTransaction.type">
                                <option value="deposit">Deposit</option>
                                <option value="withdraw">Withdraw</option>
                            </select>
                            @error('newTransaction.type') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="form-group mb-3">
                            <label for="amount">Amount</label>
                            <input type="number" 
                                   class="form-control @error('newTransaction.amount') is-invalid @enderror" 
                                   id="amount" 
                                   wire:model="newTransaction.amount"
                                   step="0.00000001"
                                   min="0">
                            @error('newTransaction.amount') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="form-group mb-3">
                            <label for="description">Description</label>
                            <input type="text" 
                                   class="form-control @error('newTransaction.description') is-invalid @enderror" 
                                   id="description" 
                                   wire:model="newTransaction.description">
                            @error('newTransaction.description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        @if($newTransaction['type'] === 'withdraw')
                        <div class="form-group mb-3">
                            <label for="to_address">To Address</label>
                            <input type="text" 
                                   class="form-control @error('newTransaction.to_address') is-invalid @enderror" 
                                   id="to_address" 
                                   wire:model="newTransaction.to_address">
                            @error('newTransaction.to_address') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        @endif

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Create Transaction</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif
    @endif
</div>