@extends('layouts.app')

@section('content')
<div class="vh-100 d-flex justify-content-center">
    <div class="form-access my-auto">
        <form method="POST" action="{{ route('login') }}">
            @csrf
            <span>Sign In</span>
            
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="form-group">
                <input type="email" class="form-control" name="email" placeholder="Email Address" required>
            </div>
            <div class="form-group">
                <input type="password" class="form-control" name="password" placeholder="Password" required>
            </div>
            <button type="submit" class="btn btn-primary">Sign In</button>
            <h2>Don't have an account? <a href="{{ route('register') }}">Sign up here</a></h2>
        </form>
    </div>
</div>
@endsection