<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\CurrencyRatesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Authentication Routes
Route::get('/login', [UserController::class, 'showLoginForm'])->name('login');
Route::post('/login', [UserController::class, 'login']);
Route::post('/logout', [UserController::class, 'logout'])->name('logout');

// Registration Routes
Route::get('/signup', [UserController::class, 'showRegistrationForm'])->name('register');
Route::post('/signup', [UserController::class, 'register']);

//only for logged in users
Route::middleware('auth')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/profile', function () {
        return view('profile');
    })->name('profile');
    
    Route::get('/wallet', function () {
        return view('wallet');
    })->name('wallet');
});

// Admin Routes
Route::prefix('admin')->middleware(['auth', 'role:admin'])->group(function () {
    Route::get('/addresses', [AdminController::class, 'addresses'])->name('admin.addresses');
    Route::get('/promo-codes', [AdminController::class, 'promoCodes'])->name('admin.promo-codes');
    
    Route::get('/currencies', [AdminController::class, 'currencies'])->name('admin.currencies');
});

Route::prefix('admin')->middleware(['auth', 'role:admin|manager'])->group(function () {
    Route::get('/', [AdminController::class, 'index'])->name('admin.dashboard');
    Route::get('/orders', [AdminController::class, 'orders'])->name('admin.orders');
    
    Route::get('/users', [AdminController::class, 'users'])->name('admin.users');
    Route::get('/users/{user}/edit', [AdminController::class, 'editUser'])->name('admin.users.edit');
    Route::post('/users/{user}/comments', [AdminController::class, 'addComment'])->name('admin.users.comments.add');
    Route::delete('/users/{user}/comments/{comment}', [AdminController::class, 'deleteComment'])->name('admin.users.comments.delete');
    Route::put('/users/{user}/edit', [AdminController::class, 'updateUser'])->name('admin.users.edit');

    Route::get('/users/{user}/login-as', [AdminController::class, 'loginAsUser'])->name('admin.users.login-as');
    
    // Transaction Routes
    Route::get('/transactions', [TransactionController::class, 'index'])->name('admin.transactions');
    Route::post('/transactions/{transaction}/confirm', [TransactionController::class, 'confirm'])->name('admin.transactions.confirm');
});

Route::get('/currency-rates/stream', [CurrencyRatesController::class, 'stream']);
