<div class="container-fluid px-4">
    <!--[if BLOCK]><![endif]--><?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="card mb-4">
        <div class="card-header">
            <i class="icon ion-md-cash mr-1"></i>
            Deposit & Withdraw Transactions
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>To Address</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($transaction->id); ?></td>
                            <td><?php echo e($transaction->user->name); ?> (<?php echo e($transaction->user->email); ?>)</td>
                            <td><?php echo e(ucfirst($transaction->type)); ?></td>
                            <td><?php echo e($transaction->description); ?></td>
                            <td><?php echo e(rtrim(rtrim(number_format($transaction->amount, 8), '0'), '.')); ?></td>
                            <td><?php echo e($transaction->to_address ?? 'N/A'); ?></td>
                            <td><?php echo e($transaction->created_at ? $transaction->created_at->format('Y-m-d H:i:s') : '-'); ?></td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if($transaction->confirmed): ?>
                                    <span class="badge badge-success">Confirmed</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if(!$transaction->confirmed && $transaction->type == 'deposit'): ?>
                                <button wire:click="confirmTransaction(<?php echo e($transaction->id); ?>)" class="btn btn-success btn-sm" onclick="return confirm('Are you sure you want to confirm this transaction?')">Confirm</button>
                                <?php else: ?>
                                    -
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center">No transactions found.</td>
                        </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/viktorion/public_html/webtrader-new/resources/views/livewire/admin-transactions.blade.php ENDPATH**/ ?>